/*
 * Decompiled with CFR 0.152.
 */
package dop;

import dop.CalendarListener;
import dop.CalendarService;
import dop.DayCalendar;
import dop.DayEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public class CalendarClient
extends UnicastRemoteObject
implements CalendarListener {
    private static DateFormat dform = DateFormat.getDateInstance(2, Locale.US);

    public static void main(String[] args) {
        String hostname = "localhost";
        if (args.length > 0) {
            hostname = args[0];
        } else {
            System.out.println("No hostname provided, using \"localhost\"");
        }
        try {
            String wtcName = "World Trade Center";
            String cccName = "Convention Conference Center";
            String calServName = "//" + hostname + "/Calendar";
            CalendarService calServ = (CalendarService)Naming.lookup(calServName);
            if (!calServ.exists(wtcName)) {
                calServ.createCalendar(wtcName);
            }
            if (!calServ.exists(cccName)) {
                calServ.createCalendar(cccName);
            }
            ArrayList allCals = calServ.getCalendars();
            System.out.print("Known calendars: ");
            for (DayCalendar dayCal : allCals) {
                System.out.print("\"" + dayCal.getName() + "\" ");
            }
            System.out.println("\n");
            calServ.removeCalendar(cccName);
            allCals = null;
            Iterator iter = null;
            System.gc();
            DayCalendar wtc = calServ.getCalendar(wtcName);
            BufferedReader kbdIn = new BufferedReader(new InputStreamReader(System.in));
            CalendarClient calist = new CalendarClient();
            wtc.addListener(calist);
            System.out.println("You now can enter a new event (type \"quit\" to stop).");
            while (true) {
                Date date;
                System.out.println("What: ");
                String what = kbdIn.readLine();
                if (what.trim().toLowerCase().equals("quit")) {
                    System.exit(0);
                }
                while (true) {
                    if ((date = CalendarClient.askForDate(kbdIn)) == null) {
                        System.out.print("You must start all over again!");
                        break;
                    }
                    if (wtc.isFree(date)) break;
                    System.out.println(dform.format(date) + " is not a free date, try another one!");
                }
                if (date != null) {
                    DayEvent event = new DayEvent(date, what);
                    wtc.plan(event);
                }
                CalendarClient.listEvents(wtc);
                if (wtc.getEventForDate(new Date("Jan 12, 2009")) != null) {
                    System.out.println("OK");
                    continue;
                }
                System.out.println("Rien");
            }
        }
        catch (Exception e) {
            System.out.println("Problem: " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private static void listEvents(DayCalendar wtc) throws RemoteException {
        String[] elist = wtc.listEvents();
        System.out.println("\n---\nFull day events for \"" + wtc.getName() + "\":");
        for (int i = 0; i < elist.length; ++i) {
            System.out.println("  - " + elist[i]);
        }
        System.out.println("\n---\n");
    }

    private static Date askForDate(BufferedReader kbdIn) throws IOException {
        int attempts = 3;
        Date date = null;
        while (true) {
            try {
                System.out.println("When: ");
                String when = kbdIn.readLine();
                if (when.trim().toLowerCase().equals("quit")) {
                    System.exit(0);
                }
                date = dform.parse(when);
            }
            catch (ParseException e) {
                System.out.print("oups, wrong date format");
                if (attempts == 0) {
                    System.out.println(", no more attempts!");
                    break;
                }
                System.out.println(", try again!");
                --attempts;
                continue;
            }
            break;
        }
        return date;
    }

    public void eventPlanned(DayEvent e) throws RemoteException {
        System.out.println("--> New event planned: " + e);
    }
}

