/*
 * Decompiled with CFR 0.152.
 */
package dop;

import dop.CalendarException;
import dop.CalendarListener;
import dop.DayCalendar;
import dop.DayEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

public class DayCalendarImpl
extends UnicastRemoteObject
implements DayCalendar,
Unreferenced {
    private TreeSet eventSet;
    private String name;
    private static DateFormat dform = DateFormat.getDateInstance(2, Locale.US);
    private ArrayList listeners;

    public DayCalendarImpl(String name) throws RemoteException {
        this.name = name;
        this.listeners = new ArrayList();
        Comparator eventComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                DayEvent e1 = (DayEvent)o1;
                DayEvent e2 = (DayEvent)o2;
                return e1.when.compareTo(e2.when);
            }
        };
        this.eventSet = new TreeSet(eventComp);
    }

    public boolean isFree(Date date) throws RemoteException {
        DayEvent testEvent = new DayEvent(date, "test");
        return !this.eventSet.contains(testEvent);
    }

    public String[] listEvents() throws RemoteException {
        String[] events = new String[this.eventSet.size()];
        Iterator iter = this.eventSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            events[i++] = iter.next().toString();
        }
        return events;
    }

    public DayEvent plan(DayEvent event) throws RemoteException, CalendarException {
        if (this.eventSet.contains(event)) {
            throw new CalendarException("Date " + dform.format(event.when) + " is not free");
        }
        this.eventSet.add(event);
        this.notifyListeners(event);
        return event;
    }

    public String getName() throws RemoteException {
        return this.name;
    }

    public void addListener(CalendarListener l) throws RemoteException {
        this.listeners.add(l);
    }

    private void notifyListeners(DayEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            try {
                ((CalendarListener)iter.next()).eventPlanned(e);
            }
            catch (RemoteException re) {
                System.err.println("Notification failed");
            }
        }
    }

    private static Date askForDate(BufferedReader kbdIn) throws IOException {
        int attempts = 3;
        Date date = null;
        while (true) {
            try {
                System.out.print("When: ");
                String when = kbdIn.readLine();
                if (when.trim().toLowerCase().equals("quit")) break;
                date = dform.parse(when);
            }
            catch (ParseException e) {
                System.out.print("oups, wrong date format");
                if (attempts == 0) {
                    System.out.println(", no more attempts!");
                    break;
                }
                System.out.println(", try again!");
                --attempts;
                continue;
            }
            break;
        }
        return date;
    }

    public DayEvent getEventForDate(Date date) throws RemoteException {
        for (DayEvent d : this.eventSet) {
            if (d.when.compareTo(date) != 0) continue;
            return d;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        System.out.println("-> This time, " + this.name + " is really about to be garbage collected... so bye bye cruel world!");
    }

    public void unreferenced() {
        System.out.println("ds unref imp");
        System.out.println("-> Oups, " + this.name + " is no longer remotely referenced!");
    }
}

