/*
 * Decompiled with CFR 0.152.
 */
package dop;

import dop.CalendarException;
import dop.CalendarService;
import dop.DayCalendar;
import dop.DayCalendarImpl;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Hashtable;

public class CalendarServer
extends UnicastRemoteObject
implements CalendarService,
Unreferenced {
    private Hashtable calendars = new Hashtable();

    public static void main(String[] args) throws Exception {
        try {
            LocateRegistry.createRegistry(1099);
            System.out.println("RMI registry ready.");
        }
        catch (Exception e) {
            System.out.println("Exception starting RMI registry:");
            e.printStackTrace();
        }
        Naming.rebind("Calendar", new CalendarServer());
    }

    public DayCalendar createCalendar(String name) throws RemoteException, CalendarException {
        if (this.calendars.containsKey(name)) {
            throw new CalendarException("Calendar \"" + name + "\" already exists.");
        }
        DayCalendarImpl newCal = new DayCalendarImpl(name);
        this.calendars.put(name, newCal);
        return newCal;
    }

    public DayCalendar getCalendar(String name) throws RemoteException, CalendarException {
        if (!this.calendars.containsKey(name)) {
            throw new CalendarException("Calendar \"" + name + "\" does not exist.");
        }
        return (DayCalendar)this.calendars.get(name);
    }

    public ArrayList getCalendars() throws RemoteException {
        return new ArrayList(this.calendars.values());
    }

    public boolean exists(String name) throws RemoteException {
        return this.calendars.containsKey(name);
    }

    public void removeCalendar(String name) throws RemoteException {
        this.calendars.remove(name);
        System.out.println("ds remove");
        System.out.println("-> " + name + " was removed from the CalendarServer's hashtable.");
        System.gc();
    }

    public void unreferenced() {
        System.out.println("ds unref");
        System.out.println("-> Oups, *the* Calendar server is no longer remotely referenced!");
    }
}

