object Dijkstra extends App {

  def dijkstra(graph: Map[String, Map[String, Map[String, Double]]], source: String): (scala.collection.mutable.Map[String, Double], scala.collection.mutable.Map[String, String]) = {
    var v_set = scala.collection.mutable.Map[String, String]()
    var dist = scala.collection.mutable.Map[String, Double]()
    var prev = scala.collection.mutable.Map[String, String]()

    for (node <- graph.keys) {
      dist(node) = Double.PositiveInfinity
      prev(node) = ""
      v_set(node) = ""
    }

    dist(source) = 0

    while (v_set.nonEmpty) {
      var u = get_nearest(v_set, dist)
      v_set.remove(u)

      for (v <- graph(u)("neighbours").keys) {
        if (v_set.contains(v)) {
          var alt = dist(u) + graph(u)("neighbours")(v)
          if (alt < dist(v)) {
            dist(v) = alt
            prev(v) = u
          }
        }
      }
    }
    
    return (dist, prev)
  }

  def get_nearest(v_set: scala.collection.mutable.Map[String, String], dist: scala.collection.mutable.Map[String, Double]): String = {
    var nearest = ""
    for (node <- v_set.keys) {
      if (nearest == "") {
        nearest = node
      }
      if (dist(node) < dist(nearest)) {
        nearest = node
      }
    }
    return nearest
  }

  var graph = Map(
    "s" -> Map(
      "neighbours" -> Map(
        "u" -> 10.0,
        "x" -> 5.0
      )
    ),
    "u" -> Map(
      "neighbours" -> Map(
        "x" -> 1.0,
        "v" -> 2.0
      )
    ),
    "x" -> Map(
      "neighbours" -> Map(
        "y" -> 2.0,
        "v" -> 9.0
      )
    ),
    "v" -> Map(
      "neighbours" -> Map(
        "y" -> 4.0,
      )
    ),
    "y" -> Map(
      "neighbours" -> Map(
        "u" -> 5.0,
      )
    ),
  )

  val start = scala.io.StdIn.readLine("Enter the starting node: ")
  val destination = scala.io.StdIn.readLine("Enter the destination node: ")

  val dijkstra_result = dijkstra(graph, start)
  val distances = dijkstra_result._1
  val previous = dijkstra_result._2

  // Impression du cout du chemin plus court
  println(s"Distance to ${destination} from ${start}: ${distances(destination)}")

  // Impression du chemin plus court
  if (distances(destination) == Double.PositiveInfinity){
    println("No path to destination")
  }
  else {
    var path = destination
    var previous_node = previous(destination)
    path = previous_node + " -> " + path
    while (previous_node != start){
      previous_node = previous(previous_node)
      path = previous_node + " -> " + path
    }
    println("Path: " + path)
  }
}
