//
//  main.swift
//  ShortestPathAlgoSwift
//
//  Created by Yannick Patschke on 06.11.17.
//  Copyright © 2017 Yannick Patschke. All rights reserved.
//

import Foundation

func Dijkstra(Graph: [String: [String: Int]], source: String, end: String) -> String {

    //create min distance
    func dist() -> [String: Int] {
        
        var dist = [String: Int]()
        for v in Graph.keys {
            dist[v] = 100000
        }
        dist[source] = 0
        
        
        var unvisited = [String]()
        for v in Graph.keys{
            unvisited.append(v)
        }
        
        var x = 0
        var stop = false
        while(!unvisited.isEmpty && stop==false){
            for node in unvisited {
                
                for (k,v) in Graph[node]! {
                    if (Int(dist[node]!) + v < Int(dist[k]!)) {
                        dist[k] = Int(dist[node]!) + v
                    }
                }
                if (dist[node] != 100000) {
                    var nn=0
                    var nnn=0
                    for n in unvisited{
                        if(n==node){
                            nnn=nn
                        }
                        nn+=1
                    }
                    unvisited.remove(at: nnn)
                }
            }
            x += 1
            if (x > 100) {
                stop=true
            }
        }
        
        return dist
    }
    
    
    //create predecessor
    func pred() -> [String: String]  {
        var D = [String: Int]()
        D = dist() // dictionary of final distances
        
        var pred = [String: String]()
        
        for p in Graph.keys {
            for (k,v) in Graph[p]! {
                if(pred[k] == nil){
                    pred[k] = p
                    
                }
                else {
                    if (D[p]! + v < D[pred[k]!]! + (Graph[pred[k]!]?[k])!) {
                        pred[k] = p
                    }
                }
                
            }
        }
        
        return pred
    }
    
    // give the shortest path
    func shortestPath(source: String, end: String) -> [String] {
        var P = [String: String]()
        P = pred()  //dictionary of predecessors
        
        var path = [String]()
        var e = end
        let s = source
        var stop = false
        while(stop==false){
            path.append(e)
            if(e == s || P[e] == nil){
                stop=true
            }else{
                e = P[e]!
            }
        }
        path.reverse()
        
        return path
    }
    
    let allPath = "All distances from " + source + ": " + String(describing: dist()) + "\nShortest path from " + source + " to " + end + ": " + String(describing: shortestPath(source: source, end: end)) + " takes "+String(Int(dist()[end]!))+" units"
    
    return allPath
}

var S = [String: Int]()
S["u"] = 10
S["x"] = 5
var U = [String: Int]()
U["v"] = 2
U["x"] = 1
var V = [String: Int]()
V["y"] = 4
var X = [String: Int]()
X["v"] = 9
X["y"] = 2
var Y = [String: Int]()
Y["u"] = 5

var G = [String: [String: Int]]()
G["s"] = S
G["u"] = U
G["v"] = V
G["x"] = X
G["y"] = Y

while(true){
print("Which source ?")
let source = readLine()
print("Which end ?")
let end = readLine()
print(Dijkstra(Graph: G, source: source!, end: end!))
}



