# Project: untitled1
# Filename: Dijkstra.py
# Created on 06.11.17 by francesco
# Last modified on 06.11.17 by francesco


def dijkstra(graph, source):
    v_set = {}
    dist = {}
    prev = {}

    for node in graph:
        dist[node] = float('inf')
        prev[node] = None
        v_set[node] = None

    dist[source] = 0

    while v_set != {}:
        u = get_nearest(v_set, dist)
        v_set.pop(u)

        for v in graph[u]['neighbours']:
            if v in v_set:
                alt = dist[u] + graph[u]['neighbours'][v]
                if alt < dist[v]:
                    dist[v] = alt
                    prev[v] = u

    return dist, prev


def get_nearest(v_set, dist):
    nearest = None
    for node in v_set:
        if nearest is None:
            nearest = node
        if dist[node] < dist[nearest]:
            nearest = node

    return nearest

graph = {
    's': {
        'neighbours': {
            'u': 10,
            'x': 5,
        }
    },
    'u': {
        'neighbours': {
            'x': 1,
            'v': 2,
        }
    },
    'x': {
        'neighbours': {
            'y': 2,
            'v': 9,
        }
    },
    'v': {
        'neighbours': {
            'y': 4,
        }
    },
    'y': {
        'neighbours': {
            'u': 5,
        }
    }
}

choices = [i for i in graph.keys()]
start = input("Enter the starting node {0}:".format(choices))
destination = input("Enter the destination node {0}:".format(choices))
distances, previous = dijkstra(graph, start)
print("Distance to {0} from {1}: {2}".format(destination, start, distances[destination]))

if distances[destination] == float('inf'):
    print("No Path to Destination")
else:
    path = destination
    previous_node = previous[destination]
    path = previous_node + ' -> ' + path
    while previous_node != start:
        previous_node = previous[previous_node]
        path = previous_node + ' -> ' + path

    print("Path: ", path)