//
//  ViewController.swift
//  exo_3-2
//
//  Created by Francesco Servida on 30.09.17.
//  Copyright © 2017 Francesco Servida. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

	@IBOutlet weak var year: UITextField!
	@IBOutlet weak var month: UITextField!
	@IBOutlet weak var day: UITextField!
	@IBOutlet weak var result: UILabel!
	
	override func viewDidLoad() {
		super.viewDidLoad()
		// Do any additional setup after loading the view, typically from a nib.
	}

	@IBAction func checkAge(_ sender: Any) {
		let today = Date()
		var birthdayComponents = DateComponents()
		birthdayComponents.year = Int(year.text!)
		birthdayComponents.month = Int(month.text!)
		birthdayComponents.day = Int(day.text!)
		
		let calendar = Calendar.current
		let birthday = calendar.date(from: birthdayComponents)!
		
		// Calculate difference btw today and birthday (in seconds) and
		// convert to years
		let age = today.timeIntervalSince(birthday)/60/60/24/365

		if (age >= 18) {
			result.text = "Old enough to enter!"
		}
		else {
			result.text = "Too young!"
		}
	}
	
	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}


}

