# -*- coding: utf-8 -*-

class A:
    def m(self):
        print("m of A called")


class B(A):
    def m(self):
        print("m of B called")


class C():
    def m(self):
        print("m of C called")


class D(B, C):
    def m(self):
        print("m of D called")
        super().m()

if __name__ == '__main__':
    d = D()
    # try to invoke the method m in different classes and check which one is called
    d.m()
    print(d)
    # displays the order in which the classes are parsed to find a method
    print(D.mro())

# mro() stands for Method Resolution Order.
# It returns a list of types the class is derived from, in the order they are searched for methods