# -*- coding: utf-8 -*-

class person():
    def __init__(self, fname: str, lname: str):
        if self.__class__ == person:
            raise NotImplementedError
        self._fname = str(fname)
        self._lname = str(lname)
        self._married = None

    def get_gender(self):
        raise NotImplementedError

    def marry(self, married):
        self._checkBeforeMarry()
        married._checkBeforeMarry()

        self._marry(married)
        married._marry(self)

    def _checkBeforeMarry(self):
        if self.is_married():
            raise Exception(str(self) + " is already married. Get divorced first.")

    def _checkBeforeDivorce(self):
        if not self.is_married():
            raise Exception(str(self) + " is not married. Get married first.")

    def _marry(self, married):
        self._married = married

    def is_married(self):
        return self._married is not None


class female(person):
    def __init__(self, fname: str, lname: str):
        self._name_married = ""
        super().__init__(fname, lname)

    def get_gender(self):
        return "F"

    def _marry(self, married):
        super()._marry(married)
        if married.get_gender() == "M":
            self._nom_marital = married._lname

    def __str__(self):
        return ("Mme." if self.is_married() else "Mlle.") + " " + self._fname + " " + self._lname + " " + (self._name_married if self.is_married() else "")


class male(person):
    def get_gender(self):
        return "M"

    def __str__(self):
        return "M. " + self._fname + " " + self._lname


if __name__ == '__main__':
    x = male("A", "B")
    y = male("C", "D")
    z = female("E", "F")
    print(x,y,z)
    z.marry(x)
    print(x,y,z)
