import scala.collection.mutable.ListBuffer

object Main extends App{

  class Library() {
    var library: ListBuffer[Book] = new ListBuffer[Book]

    def store(book: Book): Unit = {
      var n: Int = exists(book.title)
      if (n == -1) {
        library.append(book)
        println("Book " + book.title + " successfully added !")
      } else {
        println("Something went wrong with book " + book.title)
      }
    }

    def remove(name: String): Boolean = {
      var n: Int = exists(name)
      if (n != -1) {
        library.remove(n)
        println("Book " + name + " successfully removed !")
        return true
      }
      println("Something went wrong with book " + name)
      return false
    }

    def exists(name: String): Int = {
      for (i <- 0 to library.length-1) {
        if (library(i).title == name) {
          return i
        }
      }
      return -1
    }

    def printAll(): Unit = {
      println("-- LIBRARY --")
      println("--------------------------------------------------------")
      println("TITLE, AUTHOR, CATEGORY, YEAR")
      for (i <- 0 to library.length-1) {
        var b = library(i)
        println(b.title + ", " + b.author + ", " + b.category + ", " + b.year)
      }
      println("--------------------------------------------------------")
    }
  }

  class Book(_title: String, _year: Int, _author: String, _category: String) {
    var title = _title
    var year = _year
    var author = _author
    var category = _category
  }

  var library: Library = new Library
  var B1 = new Book("Python for dummies", 2001, "Mr. Robot", "Software development")
  var B2 = new Book("How to become a billionaire ?", 1985, "Scrooge McDuck", "Economy")
  var B3 = new Book("What does bastard mean ?", 2016, "Jon Snow", "English")

  library.store(B1)
  library.store(B2)
  library.store(B3)

  library.printAll()

  library.remove("How to become a billionaire ?")

  library.printAll()
}
