//
//  main.swift
//  Week10_Swift
//
//  Created by Arnaud Gerosa on 26.11.17.
//  Copyright © 2017 Arnaud Gerosa. All rights reserved.
//

import Foundation

class Library {
    var library = [Book]()
    
    func exists(name: String) -> Int {
        for b in library {
            if (b.title == name) {
                return library.index{$0 === b}!
            }
        }
        return -1
    }
    
    func store(book: Book){
        let n:Int = exists(name: book.title)
        if (n == -1) {
            library.append(book)
            print("Book \(book.title) successfully added !")
        } else {
            print("Something went wrong with book \(book.title)")
        }
    }
    
    func remove(name: String) -> Bool {
        let n: Int = exists(name: name)
        if (n != -1) {
            library.remove(at: n)
            print("Book \(name) successfully removed !")
            return true
        }
        print("Something went wrong with book \(name)")
        return false
    }
    
    func printAll() {
        print("-- LIBRARY --")
        print("--------------------------------------------------------")
        print("TITLE, AUTHOR, CATEGORY. YEAR")
        for b in library {
            print("\(b.title), \(b.author), \(b.category), \(b.year)")
        }
        print("--------------------------------------------------------")
    }
}

class Book {
    var title, author, category: String
    var year: Int
    
    init(title: String, author: String, category: String, year: Int) {
        self.author = author
        self.category = category
        self.title = title
        self.year = year
    }
}

var library: Library = Library()
var B1 = Book(title: "Python for dummies", author: "Mr. Robot", category: "Software development", year: 2001)
var B2 = Book(title: "How to become a billionaire ?", author: "Scrooge McDuck", category: "Economy", year: 1985)
var B3 = Book(title: "What does bastard mean ?", author: "Jon Snow", category: "English", year: 2016)

library.store(book: B1)
library.store(book: B2)
library.store(book: B3)

library.printAll()

library.remove(name: "How to become a billionaire ?")

library.printAll()
