//
//  main.swift
//  Week13_Exercises_Swift
//

import Foundation

class DenseMatrix {
    
    //Create an empty matrix
    var matrix: [[Int]] = []
    
    //Matrix creation method
    init(rows: Int, cols: Int, initMatrix: (Int,Int) -> Int) {
        var i = 0
        while i < rows {
            var j = 0
            var matrixLine: [Int] = []
            while j < cols {
                matrixLine.append(initMatrix(i,j))
                j += 1
            }
            matrix.append(matrixLine)
            i += 1
        }
    }
    
    //Print the matrix
    func printMatrix() {
        print("DenseMatrix")
        for line in matrix {
            var strMatrixLine = "| "
            for nb in line {
                strMatrixLine.append("\(nb) ")
            }
            strMatrixLine.append("|")
            print("\(strMatrixLine)")
        }
    }
    
}

//Test different DenseMatrix creations

var denseMatrix1 = DenseMatrix.init(rows: 3, cols: 3, initMatrix: { (i: Int,j: Int) in i + j })
denseMatrix1.printMatrix()

var denseMatrix2 = DenseMatrix.init(rows: 3, cols: 3, initMatrix: { (i: Int,j: Int) in (i + 1) * 2 })
denseMatrix2.printMatrix()

var denseMatrix3 = DenseMatrix.init(rows: 3, cols: 3, initMatrix: { (i: Int,j: Int) in (j + 1) * 2 })
denseMatrix3.printMatrix()

var denseMatrix4 = DenseMatrix.init(rows: 3, cols: 3, initMatrix: { (i: Int,j: Int) in 7 })
denseMatrix4.printMatrix()

var denseMatrix5 = DenseMatrix.init(rows: 3, cols: 3, initMatrix: { (i: Int,j: Int) in Int(arc4random_uniform(9)) })
denseMatrix5.printMatrix()
