//Vous devez réaliser cet exercice en Scala et en Swift.

//Reprendre l'exemple de la dernière slide du cours présentant la classe DenseMatrix.
//Le but de cet exercice est d'implementer la création de plusieurs DenseMatrix à partir de différent fonctions passées en paramètre.
//Vous devez également afficher le résultat des différentes matrices comme afficher dans la slide du cours.

//Au lieu de créer une hiérarchie de classes de matrices, ré-utiliser le code implémentant DenseMatrix fourni ci-dessous (suivre une structure similaire pour la version en Sz)


object Exercise extends App {

  class DenseMatrix(private val rows: Int, private val cols: Int) {

    private val matrix = Array.ofDim[Int](rows, cols)

    def this (rows: Int, cols: Int, init: (Int,Int) => Int) {
      this(rows,cols)
      for (i <- 0 to rows - 1; j <- 0 to cols - 1)
        this.matrix(i)(j) = init(i,j)
    }

    def print(): Unit = {
      println("DenseMatrix")
      for (i <- 0 to rows - 1) {
        var strMatrixLine = "| "
        for (j <- 0 to cols - 1)
          strMatrixLine = strMatrixLine + matrix(i)(j) + " "
        strMatrixLine = strMatrixLine + "|"
        println(strMatrixLine)
      }
    }

  }

  var denseMatrix1 = new DenseMatrix(3, 3, (i,j) => i + j)
  denseMatrix1.print

  var denseMatrix2 = new DenseMatrix(3, 3, (i,j) => (i + 1) * 2)
  denseMatrix2.print

  var denseMatrix3 = new DenseMatrix(3, 3, (i,j) => (j + 1) * 2)
  denseMatrix3.print

  var denseMatrix4 = new DenseMatrix(3, 3, (i,j) => 7)
  denseMatrix4.print

  var denseMatrix5 = new DenseMatrix(3, 3, (i,j) => scala.util.Random.nextInt(5))
  denseMatrix5.print

}
